define(function () {

    var component = {
        inject: ["configuration"],
        data: function () {
            return {
                showMoreNewsToggle: true
            };
        },
        methods: {
            showMoreNews: function () {
                var _this = this;
                this.getItems(parseInt(this.webpartProperties.moreNews) +
                    parseInt(this.webpartProperties.numberOfNews)).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            },
            showLessNews: function () {
                var _this = this;
                this.getItems(this.webpartProperties.numberOfNews).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            }
        }
    };

    component.originalTemplate = "corpViewModern.twoColumns";
    component.template = `
<wizdomWebpart data-v-7b95e55b
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Corporate News' | translate"
  @titleChanged="webpartProperties.title = $event"
  :webpartPadding="false"
  chromeType="title"
  @webpart-resize="webpartResize"
>
  <div data-v-7b95e55b v-if="items.length > 0">
    <div data-v-7b95e55b class="news-items">
      <div data-v-7b95e55b class="news-item-wrapper" v-for="item in items" :key="item.date">
        <div data-v-7b95e55b class="news-item">
          <div data-v-7b95e55b class="leftSection">
            <div data-v-7b95e55b class="imageContainer">
              <a data-v-7b95e55b :href="item.path" target="_blank" class="image-link">
                <div data-v-7b95e55b class="image-image" :style="getStyle(item)">
                  <div data-v-7b95e55b
                    v-if="item.breaking && webpartProperties.breakingTag"
                    class="breaking"
                  >{{webpartProperties.breakingTagText}}</div>
                </div>
              </a>
            </div>
          </div>
          <div data-v-7b95e55b id="rightSection" class="rightSection">
            <div data-v-7b95e55b id="content" class="content">
              <a data-v-7b95e55b :href="item.path" target="_blank" class="text-link">
                <tags data-v-7b95e55b
                  v-if="item.listOfTags"
                  :tags="item.listOfTags"
                  :sizenow="sizenow"
                  ref="tags"
                ></tags>
                <div data-v-7b95e55b class="titleAndDescription">
                  <div data-v-7b95e55b class="title" :title="item.title">{{item.title}}</div>
                  <span data-v-7b95e55b
                    v-if="item.summary.length !== 0"
                    class="content-text"
                    v-html="item.summary"
                  ></span>
                  <span data-v-7b95e55b v-else class="content-text" v-html="item.content"></span>
                </div>

                <div data-v-7b95e55b class="authorNameEtc">
                  <div data-v-7b95e55b v-show="item.loginName" class="authorAvatar">
                    <img data-v-7b95e55b
                      class="authorAvatar"
                      :src="'/_layouts/15/userphoto.aspx?size=S&username=' + item.loginName"
                    />
                  </div>
                  <div data-v-7b95e55b class="author">{{item.author}}</div>
                  <span data-v-7b95e55b v-show="item.date" class="timeago">
                    <uiIconClock data-v-7b95e55b />
                    <timeago data-v-7b95e55b :since="item.date" locale="lang">></timeago>
                  </span>
                  <views data-v-7b95e55b v-if="webpartProperties.showViewCount" :views="item.views" class="views"></views>
                </div>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div data-v-7b95e55b v-if="webpartProperties.moreNews > 0" class="show-more pointer">
      <span data-v-7b95e55b v-if="showMoreNewsToggle" @click="showMoreNews()">
        {{'Show more'| translate}}
        <uiIconChevronDownMed data-v-7b95e55b />
      </span>
      <span data-v-7b95e55b v-else @click="showLessNews()">
        {{'Show less'| translate}}
        <uiIconChevronUpMed data-v-7b95e55b />
      </span>
    </div>
  </div>
  <noItem data-v-7b95e55b
    v-if="!items.length && webpartProperties.contentPlaceholder"
    :title="contentPlaceholder.title"
    :theme="true"
    :illustration="'coffee'"
  ></noItem>
</wizdomWebpart>
`;
    component.styles = `
.pointer[data-v-7b95e55b] {
  cursor: pointer;
}
.breaking[data-v-7b95e55b] {
  color: "[theme:white, default:#fff]";
  background-color: "[theme:accent, default:#0078d4]";
  position: absolute;
  top: 20px;
  left: 0;
  z-index: 1;
  text-align: center;
  padding: 5px 10px 5px 10px;
}
.summaryfix[data-v-7b95e55b] {
  font-size: 14px;
  line-height: 20px;
  margin-top: 5px;
  display: block;
  text-overflow: ellipsis;
  color: "[theme:neutralPrimaryAlt, default: #f8f8f8]";
  max-height: 21px;
  white-space: nowrap;
  overflow: hidden;
  width: 100%;
}
.news-items .news-item-wrapper[data-v-7b95e55b] {
  color: "[theme:bodyText, default: #333]";
  display: inline-block;
  box-sizing: border-box;
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
}
.news-items .news-item-wrapper .news-item[data-v-7b95e55b] {
    padding-bottom: 20px;
    padding-top: 20px;
    padding-left: 0;
    padding-right: 0;
    box-sizing: border-box;
    position: relative;
    color: "[theme:bodyText, default: #333]";
    display: table;
}
.news-items .news-item-wrapper .news-item .leftSection[data-v-7b95e55b] {
      display: table-cell;
      vertical-align: top;
}
.news-items .news-item-wrapper .news-item .rightSection[data-v-7b95e55b] {
      max-width: 280px;
      display: table-cell;
      vertical-align: top;
}
.news-items .news-item-wrapper .news-item .imageContainer[data-v-7b95e55b] {
      box-sizing: border-box;
      width: 274px;
      height: 154px;
      border: 1px solid "[theme:neutralLight, default:#eaeaea]";
      background-color: "[theme:neutralLighterAlt, default:#eaeaea]";
      box-sizing: border-box;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link[data-v-7b95e55b] {
        text-decoration: none;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image[data-v-7b95e55b] {
          height: 100%;
          width: 100%;
          position: relative;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image img[data-v-7b95e55b] {
            display: block;
            opacity: 1;
            width: 100%;
            height: auto;
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
}
.news-items .news-item-wrapper .news-item .content[data-v-7b95e55b] {
      padding-left: 14px;
      box-sizing: border-box;
      height: 154px;
      overflow: hidden;
      color: "[theme:bodyText, default: #333]";
}
.news-items .news-item-wrapper .news-item .content[data-v-7b95e55b] .tag-container {
        margin-bottom: 11px;
}
.news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-7b95e55b] {
        height: 60px;
}
.news-items .news-item-wrapper .news-item .content .title[data-v-7b95e55b] {
        margin: -5px 0 0 0;
        padding: 0;
        font-size: 21px;
        font-weight: 300;
        line-height: 27px;
        text-overflow: ellipsis;
        display: block;
        position: relative;
        max-height: 54px;
        overflow: hidden;
        color: "[theme:themePrimary, default: #0078d4]";
}
.news-items .news-item-wrapper .news-item .content .content-text[data-v-7b95e55b] {
        font-size: 14px;
        line-height: 20px;
        margin-top: 5px;
        display: block;
        text-overflow: ellipsis;
        color: "[theme:neutralPrimaryAlt, default: #8d8b8a]";
        max-height: 21px;
        overflow: hidden;
}
.news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-7b95e55b] {
        display: inline-block;
        vertical-align: top;
        float: left;
        padding-right: 5px;
}
.news-items .news-item-wrapper .news-item .content .authorAvatar img[data-v-7b95e55b] {
          width: 32px;
          height: 32px;
          border-radius: 50%;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-7b95e55b] {
        display: inline-block;
        font-size: 12px;
        vertical-align: top;
        position: absolute;
        bottom: 20px;
        width: 100%;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .author[data-v-7b95e55b] {
          margin-bottom: 2px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .timeago[data-v-7b95e55b] {
          color: "[theme:neutralPrimaryAlt, default: #8d8b8a]";
          margin-right: 5px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .timeago i[data-v-7b95e55b] {
            position: relative;
            top: 1px;
            margin-right: 2px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .views[data-v-7b95e55b] {
          display: inline-block;
          color: "[theme:neutralPrimaryAlt, default: #8d8b8a]";
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .views i[data-v-7b95e55b] {
            position: relative;
            top: 1px;
            margin-right: 1px;
}
.news-items .news-item-wrapper:first-child .news-item[data-v-7b95e55b] {
  padding-top: 0;
}
a[data-v-7b95e55b] {
  text-decoration: none;
}
.text-link[data-v-7b95e55b] {
  display: inline-block;
  width: 100%;
  color: "[theme:bodyText, default: #333]";
}
.show-more[data-v-7b95e55b] {
  padding-right: 16px;
  padding-bottom: 10px;
  color: "[theme:bodyText, default: #333]";
  float: right;
}
.show-more .show-more-icon[data-v-7b95e55b] {
    vertical-align: sub;
    color: "[theme:themePrimary, default:#0078d4]";
}

/* Styles for medium and large sized column and xlarge (currently set as default) */
/*.webpart-size-medium, .webpart-size-large, .webpart-size-xlarge {*/
/* 2 columns mode:
    - Set width to 49%
    - Set right padding on all odd news posts
    - Set the 2 first news posts to zero top-padding
    - Set the the "second to last" to zero bottom-border (if it is odd)
  */
.news-items .news-item-wrapper[data-v-7b95e55b] {
  width: 49%;
}
.news-item-wrapper[data-v-7b95e55b]:nth-child(odd) {
  padding-right: 24px;
}
.news-item-wrapper:nth-child(-n + 2) .news-item[data-v-7b95e55b] {
  padding-top: 0;
}

/*}*/
.webpart-size-medium .news-items .news-item-wrapper .news-item .imageContainer[data-v-7b95e55b] {
  width: 194px;
  height: 110px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .breaking[data-v-7b95e55b] {
  padding: 1px 8px 2px 8px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content[data-v-7b95e55b] {
  height: 110px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-7b95e55b] {
    height: 20px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .content-text[data-v-7b95e55b] {
    max-height: 30px;
    line-height: 14px;
    margin-top: 0px;
    font-size: 12px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .title[data-v-7b95e55b] {
    font-size: 17px;
    line-height: 21px;
    max-height: 21px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-7b95e55b] {
    display: none;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-7b95e55b] {
    margin: 0;
}

/* Styles for small sized column */
.webpart-size-small .news-items .news-item-wrapper .news-item .imageContainer[data-v-7b95e55b] {
  width: 126px;
  height: 94px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .breaking[data-v-7b95e55b] {
  padding: 0px 4px 1px 4px;
  font-size: 13px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content[data-v-7b95e55b] {
  height: 94px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-7b95e55b] {
    height: 60px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .content-text[data-v-7b95e55b] {
    max-height: 19px;
    line-height: 9px;
    font-size: 10px;
    margin-top: 0px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .title[data-v-7b95e55b] {
    font-size: 14px;
    line-height: 19px;
    max-height: 19px;
    font-weight: 400;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-7b95e55b] {
    display: none;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-7b95e55b] {
    width: 100%;
    margin: 0;
}

/* 1 column mode */
.webpart-size-small .news-items .news-item-wrapper[data-v-7b95e55b],
.webpart-size-medium .news-items .news-item-wrapper[data-v-7b95e55b] {
  width: 100%;
}
.webpart-size-small .news-item-wrapper:nth-child(2) .news-item[data-v-7b95e55b],
.webpart-size-medium .news-item-wrapper:nth-child(2) .news-item[data-v-7b95e55b] {
  padding-top: 20px;
}
.webpart-size-small .news-item-wrapper[data-v-7b95e55b]:last-child,
.webpart-size-medium .news-item-wrapper[data-v-7b95e55b]:last-child {
  border-bottom: 0px;
}

/* 2 column mode */
.webpart-size-large .news-item-wrapper[data-v-7b95e55b]:nth-last-child(2):nth-child(odd) {
  border-bottom: 0px;
}
.webpart-size-large .news-item-wrapper[data-v-7b95e55b]:last-child {
  border-bottom: 0px;
}


`;

    return component;

});
